<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class AddJobAndInterviewLimitsToPlans extends Migration
{
    public function up()
    {
        Schema::table('plans', function (Blueprint $table) {
            if (!Schema::hasColumn('plans', 'Max_Job_Postings')) {
                $table->integer('Max_Job_Postings')->default(0)->after('Access_Level');
            }
            if (!Schema::hasColumn('plans', 'Max_Interview_Schedules')) {
                $table->integer('Max_Interview_Schedules')->default(0)->after('Max_Job_Postings');
            }
        });
    }

    public function down()
    {
        Schema::table('plans', function (Blueprint $table) {
            if (Schema::hasColumn('plans', 'Max_Job_Postings')) {
                $table->dropColumn('Max_Job_Postings');
            }
            if (Schema::hasColumn('plans', 'Max_Interview_Schedules')) {
                $table->dropColumn('Max_Interview_Schedules');
            }
        });
    }
}
